local t = Def.ActorFrame {};
local mLifeScale = tonumber(PREFSMAN:GetPreference("LifeDifficultyScale"));
local fLifeScale = scale(mLifeScale,0.60000002384186,1.3999999761581,1,5);
local fLifeScaleFixed = scale(mLifeScale,0.60000002384186,1.3999999761581,0,1);

local iSongs = SONGMAN:GetNumSongs();
local iAddSongs = SONGMAN:GetNumAdditionalSongs();
local iTotal = iSongs + iAddSongs;
-- if anyone has more than 50,000 songs (aside from Shuey),
-- I will personally hit them -aj
-- p.s. I doubt anyone has a million simfiles unless they're being hyper-pedantic
-- and keeping 500 duplicates (and I don't mean some of the sensible ddruk dupes,
-- either).
local iSongMilestones = {
	200, 500, 1000, 1500, 2000, 2500, 3000, 4000, 5000, 10000, 20000, 50000, 100000, 1000000
};
local function GetMilestone()
	for _, m in ipairs(iSongMilestones) do
		if iTotal <= m then
			-- use this milestone
			return m;
		end;
	end;
	return iSongMilestones[#iSongMilestones];
end;

local iSongScale = scale(iTotal,0,GetMilestone(),0,1);

t[#t+1] = Def.ActorFrame {
	LoadActor( THEME:GetPathB("","_frame 3x3"), "Pref", 80, 32)..{
		InitCommand=cmd(y,SCREEN_TOP+80-40;x,SCREEN_LEFT+128-64+128);
	};
	Def.Quad {
		InitCommand=cmd(y,SCREEN_TOP+16+20;x,SCREEN_LEFT+64+128;zoomto,100,20);
		OnCommand=cmd(diffuse,0,0,0,0.5);
	};
	Def.Quad {
		InitCommand=cmd(y,SCREEN_TOP+16+20;x,SCREEN_LEFT+64+128;zoomto,100-4,20-4);
		OnCommand=cmd(diffusealpha,0.1);
	};
	Def.Quad {
		InitCommand=cmd(y,SCREEN_TOP+16+20;x,SCREEN_LEFT+64-48+128;zoomto,(100-4)*iSongScale,20-4);
		OnCommand=cmd(horizalign,left;diffuse,cBlue;diffusetopedge,LightColor(cBlue);playcommand,"Set");
		SetCommand=function(self)
			if iTotal >= GetMilestone()-25 then -- was if iTotal > 200 then
				self:diffuse(cRed);
				self:diffusetopedge(LightColor(cRed));
				self:diffuseleftedge(LightColor(cOrange));
			else
				self:diffuse(cBlue);
				self:diffusetopedge(LightColor(cBlue));
			end
		end
	};
	LoadFont("Common Normal") .. {
		Text="Songs";
		InitCommand=cmd(y,SCREEN_TOP+16+40+4;x,SCREEN_LEFT+64-10+128;NoStroke;shadowlength,1);
		OnCommand=cmd(horizalign,right;zoom,0.5);
	};
	LoadFont("Common Normal") .. {
		Text=string.format("%04d",iTotal);
		InitCommand=cmd(y,SCREEN_TOP+16+40+1;x,SCREEN_LEFT+64+48+128;NoStroke;shadowlength,1);
		OnCommand=cmd(horizalign,right;zoom,0.875);
	};
};

t[#t+1] = Def.ActorFrame {
	LoadActor( THEME:GetPathB("","_frame 3x3"), "Pref", 80, 32)..{
		InitCommand=cmd(y,SCREEN_TOP+80-40;x,SCREEN_LEFT+128-64);
	};
	Def.Quad {
		InitCommand=cmd(y,SCREEN_TOP+16+20;x,SCREEN_LEFT+64;zoomto,100,20);
		OnCommand=cmd(diffuse,0,0,0,0.5);
	};
	Def.Quad {
		InitCommand=cmd(y,SCREEN_TOP+16+20;x,SCREEN_LEFT+64;zoomto,100-4,20-4);
		OnCommand=cmd(diffusealpha,0.1);
	};
	Def.Quad {
		InitCommand=cmd(y,SCREEN_TOP+16+20;x,SCREEN_LEFT+64-48;;zoomto,(100-4)*fLifeScaleFixed,20-4);
		OnCommand=cmd(horizalign,left;diffuse,cBlue;diffusetopedge,LightColor(cBlue));
	};
	LoadFont("Common Normal") .. {
		Text="Life Scale";
		InitCommand=cmd(y,SCREEN_TOP+16+40+4;x,SCREEN_LEFT+64+14;NoStroke;shadowlength,1);
		OnCommand=cmd(horizalign,right;zoom,0.5);
	};
	LoadFont("Common Normal") .. {
		Text=string.format("%02x",fLifeScale);
		InitCommand=cmd(y,SCREEN_TOP+16+40;x,SCREEN_LEFT+64+48;NoStroke;shadowlength,1);
		OnCommand=cmd(horizalign,right);
	};
};

return t;
